(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3830,        116]*)
(*NotebookOutlinePosition[      4473,        138]*)
(*  CellTagsIndexPosition[      4429,        134]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(graf = 
      Plot[Evaluate[Table[n^2\ x\ Exp[\(-n\)*x], {n, 1, 6}]], {x, 0, 1}, 
        PlotStyle \[Rule] Table[Hue[n/3], {n, 1, 6}], 
        PlotPoints \[Rule] 50]\)], "Input"],

Cell[BoxData[
    \(Export["\<suc1.pdf\>", %, "\<PDF\>", 
      ImageSize \[Rule] {288, 178}]\)], "Input"],

Cell[BoxData[
    \(\(graf2 = 
        Plot[Evaluate[
            Table[2  n*x^2/\((n^2\ \ x^4\  + \ 1)\), {n, 1, 6}]], {x, 0, 2}, 
          PlotStyle \[Rule] Table[Hue[n/3], {n, 1, 12, 2}], 
          PlotPoints \[Rule] 50];\)\)], "Input"],

Cell[BoxData[
    \(Export["\<suc2.pdf\>", %, "\<PDF\>", 
      ImageSize \[Rule] {288, 178}]\)], "Input"],

Cell[BoxData[
    \(\(g[n_, x_, \[Alpha]_] = n\^\[Alpha]\ x \((1 - x\^2)\)\^n;\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[Table[g[n, x, 1/4], {n, 1, 12, 2}]], {x, 0, 1}, 
        PlotStyle \[Rule] Table[Hue[n/3], {n, 1, 24, 4}], 
        PlotPoints \[Rule] 50];\)\)], "Input"],

Cell[BoxData[
    \(Export["\<suc3a.pdf\>", %, "\<PDF\>", 
      ImageSize \[Rule] {288, 178}]\)], "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[Table[g[n, x, 1/2], {n, 1, 12, 2}]], {x, 0, 1}, 
        PlotStyle \[Rule] Table[Hue[n/3], {n, 1, 24, 4}], 
        PlotPoints \[Rule] 50];\)\)], "Input"],

Cell[BoxData[
    \(Export["\<suc3b.pdf\>", %, "\<PDF\>", 
      ImageSize \[Rule] {288, 178}]\)], "Input"],

Cell[BoxData[
    \(\(f[n_, x_] = n*\(Cos[x]\^n\) Sin[x];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[Table[f[n, x], {n, 1, 24, 4}]], {x, 0, \[Pi]/2}, 
        PlotStyle \[Rule] Table[Hue[n/3], {n, 1, 24, 4}], 
        PlotPoints \[Rule] 50];\)\)], "Input"],

Cell[BoxData[
    \(Export["\<suc4.pdf\>", %, "\<PDF\>", 
      ImageSize \[Rule] {288, 178}]\)], "Input"],

Cell[BoxData[
    \(\(f[n_, x_] = Sin[n*x]\^2\/\(n*Sin[x]\);\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[Table[f[n, x], {n, 1, 12, 2}]], {x, 0, \[Pi]}, 
        PlotStyle \[Rule] Table[Hue[n/3], {n, 1, 24, 4}], 
        PlotPoints \[Rule] 50];\)\)], "Input"],

Cell[BoxData[
    \(Export["\<suc5.pdf\>", %, "\<PDF\>", 
      ImageSize \[Rule] {288, 178}]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{1, Automatic}, {Automatic, 28}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 200, 4, 50, "Input"],
Cell[1908, 56, 106, 2, 30, "Input"],
Cell[2017, 60, 241, 5, 50, "Input"],
Cell[2261, 67, 106, 2, 30, "Input"],
Cell[2370, 71, 93, 1, 31, "Input"],
Cell[2466, 74, 190, 3, 50, "Input"],
Cell[2659, 79, 107, 2, 30, "Input"],
Cell[2769, 83, 190, 3, 50, "Input"],
Cell[2962, 88, 107, 2, 30, "Input"],
Cell[3072, 92, 72, 1, 30, "Input"],
Cell[3147, 95, 191, 3, 50, "Input"],
Cell[3341, 100, 106, 2, 30, "Input"],
Cell[3450, 104, 75, 1, 47, "Input"],
Cell[3528, 107, 189, 3, 50, "Input"],
Cell[3720, 112, 106, 2, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

